#include "stdafx.h"
#include "script.h"
#include "scriptDoc.h"
#include "sipapi.h"
#include "string.h"

const TCHAR *findSubstringCaseInsensitive(const TCHAR *string, TCHAR *substring)
{
	const TCHAR *index=string;
	int compare=1;
	int len;

	if ( (!substring) || (!*substring) )
		return string;
	
	
	if (_tcslen(string)<(UINT)(len=_tcslen(substring)))
		return NULL;

	while( *index )
	{
		if( CompareString( LOCALE_SYSTEM_DEFAULT, NORM_IGNORECASE, index, len, substring, len ) == CSTR_EQUAL )
			return index;
		else
			index++;
	}
	return NULL;
/* MMD 2005-07-17
	while(*index && compare)
	{
		compare=CompareString(LOCALE_SYSTEM_DEFAULT,NORM_IGNORECASE,index,len,substring,len)-2;
		index++;
	}

	if(!compare)
		return --index;
	else
		return NULL;
*/
}

int doFillListBoxWithLinesContaining(CListBox *pListBox,CEditView *pEditView,CStringArray *pacstrMatches,BOOL bCaseSensitive,BOOL bLineBeginningsOnly,int * piStartAt,int iMaxMatches)
{
	const TCHAR *szBuf;
	TCHAR *pCurrent;
	CEdit& doc = pEditView->GetEditCtrl();
	CString cstrFind;
	int iStringIter;
	int iListBoxIndex;
	int iNumMatches = 0;
	int iStartAt = piStartAt ? *piStartAt : 0;
	CString strText;

	doc.GetWindowText( strText );
	szBuf = strText.LockBuffer();
	// szBuf = pEditView->LockBuffer();

	iStringIter=0;
	while(iStringIter<=pacstrMatches->GetUpperBound())
	{
		cstrFind=pacstrMatches->GetAt(iStringIter);

		pCurrent=(TCHAR *)szBuf;
		pCurrent+=iStartAt;
		while(pCurrent)
		{
			if(bCaseSensitive)
				pCurrent=_tcsstr(pCurrent,(LPCTSTR)cstrFind);
			else
				pCurrent=(TCHAR *)findSubstringCaseInsensitive(pCurrent,(TCHAR *)((LPCTSTR)cstrFind));

			if(pCurrent && (!bLineBeginningsOnly || (pCurrent==szBuf || *(pCurrent-1)==TEXT('\n') || *(pCurrent-1)==TEXT('\r'))))
			{
				int iCharIndex;
				TCHAR szLine[256];

				iCharIndex=pCurrent-szBuf;
				memset(szLine,0,sizeof(szLine));
				doc.GetLine(doc.LineFromChar(iCharIndex),szLine,(sizeof(szLine)/sizeof(TCHAR))-1);

				iListBoxIndex=pListBox->AddString(szLine);
				if(iListBoxIndex!=LB_ERR && iListBoxIndex!=LB_ERRSPACE)
					pListBox->SetItemData(iListBoxIndex,iCharIndex);
				iNumMatches++;
				pCurrent++;//move forward a char so we don't match the same one again..
				if (iMaxMatches && iNumMatches>=iMaxMatches)
					goto exitFillListBox;
			}//if pCurrent
			else if (pCurrent)
				pCurrent++;
		}//while pCurrent
		iStringIter++;
	}//foreach match string

exitFillListBox:
	if(piStartAt)
		*piStartAt=pCurrent-szBuf;
	strText.UnlockBuffer();
//	pEditView->UnlockBuffer();
	return iNumMatches;
}

int doExtractIntFromVariant(const VARIANT *vVariant, int iDefault)
{
	if(vVariant->vt==VT_EMPTY || vVariant->vt==VT_ERROR)
		return iDefault;
	VARIANT v;
	VariantInit(&v);
	VariantCopyInd(&v,(VARIANT *)vVariant);
	//v=*vVariant;
	VariantChangeType(&v,&v,0,VT_I2);
	return v.iVal;
}

CString doExtractCStringFromVariant(const VARIANT *vVariant, LPCTSTR szDefault)
{
	if(vVariant->vt==VT_EMPTY || vVariant->vt==VT_ERROR)
		return CString(szDefault);
	VARIANT v;
	VariantInit(&v);
	VariantCopyInd(&v,(VARIANT *)vVariant);
	//v=*vVariant;
	VariantChangeType(&v,&v,0,VT_BSTR);
	return CString(v.bstrVal);
}

LPUNKNOWN doExtractLPUNKNOWNFromVariant(const VARIANT *vVariant, LPUNKNOWN lpDefault)
{
	if( vVariant->vt == VT_EMPTY || vVariant->vt == VT_ERROR )
		return lpDefault;
	VARIANT v;
	VariantInit( &v );
	VariantCopyInd( &v, (VARIANT *)vVariant );
	VariantChangeType( &v, &v, 0, VT_UNKNOWN );
	return v.punkVal;
}

HRESULT LookupCLSID(LPCOLESTR lpszProgID, LPCLSID pclsid)
{
    // lookup lpsz\\clsid and call CLSIDFromString on the result;
    TCHAR sz[256];
    ULONG cbValue = sizeof(sz)/sizeof(TCHAR);
	HKEY hSubKey;
	LONG lResult;

    if (lpszProgID == NULL || pclsid ==NULL)
    {
        return(E_INVALIDARG);
    }

    if (*lpszProgID == 0)
    {
        return(CO_E_CLASSSTRING);
    }
	if(lpszProgID[0]==TCHAR('{'))
	{
		_tcscpy(sz,lpszProgID);
		return CLSIDFromString(sz, pclsid);
	}

    _tcscpy(sz, lpszProgID);
    _tcscat(sz, _T("\\Clsid"));


	lResult = RegOpenKeyEx(HKEY_CLASSES_ROOT, sz, 0, 0, &hSubKey);
	if(lResult != ERROR_SUCCESS)
	{//no CLSID key in this ProgID.  Perhaps it has a CurVer key?
		HKEY hTempKey;
		_tcscpy(sz,lpszProgID);
		_tcscat(sz,TEXT("\\CurVer"));

		lResult=RegOpenKeyEx(HKEY_CLASSES_ROOT,sz,0,0,&hTempKey);

		if(lResult == ERROR_SUCCESS)
		{//tempkey points to the curver key.  Get the revised ProgID
			TCHAR strValueName[60];
			DWORD dwValueNameLength=sizeof(strValueName)/sizeof(TCHAR);
			DWORD dwType;
	
			cbValue = sizeof(sz)/sizeof(TCHAR);
			lResult = RegEnumValue(hTempKey, 0, strValueName, &dwValueNameLength, 0, &dwType, (LPBYTE)sz, &cbValue);
			RegCloseKey(hTempKey);
			if(lResult==ERROR_SUCCESS && dwType==REG_SZ)
			{//We got the revised ProgID (with version info.).  Now go get the CLSID
				_tcscat(sz,TEXT("\\CLSID"));
				lResult=RegOpenKeyEx(HKEY_CLASSES_ROOT,sz,0,0,&hSubKey);
			}
		}
	}
	if (lResult == ERROR_SUCCESS)
	{
		TCHAR strValueName[60];
		DWORD dwValueNameLength=sizeof(strValueName)/sizeof(TCHAR);
		DWORD dwType;

		cbValue = sizeof(sz)/sizeof(TCHAR);
		lResult = RegEnumValue(hSubKey, 0, strValueName, &dwValueNameLength, 0, &dwType, (LPBYTE)sz, &cbValue);
		ASSERT(dwType == REG_SZ);
		ASSERT(lResult == ERROR_SUCCESS);
		RegCloseKey(hSubKey);
		return CLSIDFromString(sz, pclsid);
	}

/*    if (wce_RegQueryValue(HKEY_CLASSES_ROOT, sz, sz, &cbValue) == ERROR_SUCCESS)
    {
        return CLSIDFromString(sz, pclsid);
    }
*/
    return E_FAIL;
}

void doGetAdjustedBounds(CWnd *pCWnd,RECT *pRect,int *pLeft, int *pTop, int *pWidth, int *pHeight)
{
	RECT rectParent;
	RECT rectCtl;

	int iCurWidth,iCurHeight;

	pCWnd->GetWindowRect(&rectCtl);
	pCWnd->GetParent()->GetWindowRect(&rectParent);


	//get coords relative to parent
	OffsetRect(&rectCtl,-rectParent.left,-rectParent.top);
	iCurHeight=rectCtl.bottom-rectCtl.top;
	iCurWidth=rectCtl.right-rectCtl.left;

	if(pRect)
		*pRect=rectCtl;

	if(pLeft)
		*pLeft=rectCtl.left;

	if(pTop)
		*pTop=rectCtl.top;

	if(pWidth)
		*pWidth=iCurWidth;

	if(pHeight)
		*pHeight=iCurHeight;



}

TCHAR *doBuildSizeString(int iSize, TCHAR *szBuf)
{

	if(iSize<1024)
	{
		wsprintf(szBuf,TEXT("%i bytes"),iSize);	
	}
	else
	{
		int iWhole,iFraction;

		iWhole=iSize/1024;
		iFraction=iSize-(iWhole*1024);
		iFraction=(iFraction * 10)/1024;
		if(iFraction)
			wsprintf(szBuf,TEXT("%i.%ik"),iWhole,iFraction);
		else
			wsprintf(szBuf,TEXT("%ik"),iWhole);

	}
	return szBuf;
}

#include "resource.h"
#include "OutputWindow.h"

void doDeleteMenuRecursively(CMenu *pMenu, void *pVoidWnd)
{//pMenu = pointer to menu which is to be emptied
 //pWnd = pointer to output window which contains the lookup maps
	COutputWindow *pWnd=(COutputWindow *)pVoidWnd;
	UINT iNumItems=pMenu->GetMenuItemCount();
	UINT iItemIter;
	CMenu *pSubMenu;
	long iID;

	for(iItemIter=0;iItemIter<iNumItems;iItemIter++)
	{//walk the menu items and release them..
		//check to see if the item is a submenu
		//we're always using item#0, because we're constantly removing the top item...
		//the index in the for loop is just to get the count right.
		if(pSubMenu=pMenu->GetSubMenu(0))
		{//there is a submenu, so delete it's items recursively
			doDeleteMenuRecursively(pSubMenu,pWnd);
		}
		iID=pMenu->GetMenuItemID(0);
		if(iID!=0)
		{//not a separator
			CMenuObject *pMenuObject;
			
			if(iID==-1 && pSubMenu)
			{//submenu.  keyed on submenu HMENU instead of ID
				iID=(long)pSubMenu->m_hMenu;
			}
			//get a pointer to our menu object
			void *vptr;//=pMenuObject;
			if(pWnd->m_menuIDMap.Lookup((void *)iID,vptr))
			{
				pMenuObject=(CMenuObject *)vptr;
				//remove the cross-lookup key from the ID map
				pWnd->m_menuIDMap.RemoveKey((void *)iID);
				//remove the lookup key from the string-ID map
				pWnd->m_menus.RemoveKey(pMenuObject->cstrKey);
				delete(pMenuObject);
			}

		}
		pMenu->DeleteMenu(0,MF_BYPOSITION);
	}
}

bool isCodeValid(unsigned long lCode)
{
	return (((lCode-3000003)%71)==0);

}

typedef WINSHELLAPI BOOL	(*SHSipInfoFunc)(
								UINT uiAction,
								UINT uiParam,
								PVOID pvParam,
								UINT fWinIni );

bool mySHSipInfo(UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni)
{
	HINSTANCE hInstance;
	SHSipInfoFunc pSHSipInfo;
	bool bRetval;

#if defined(_WIN32_WCE_EMULATION)
	return false;//**MARCH99
#endif
	hInstance=LoadLibrary(TEXT("aygshell.dll"));
	if(!hInstance)
	{	
		return false;
	}
	pSHSipInfo=(SHSipInfoFunc)GetProcAddress(hInstance,TEXT("SHSipInfo"));
	if(!pSHSipInfo)
	{
		FreeLibrary(hInstance);
		return false;
	}

//	bRetval=(bool) (*pSHSipInfo)( uiAction, uiParam, pvParam, fWinIni );
	bRetval = (*pSHSipInfo)( uiAction, uiParam, pvParam, fWinIni ) ? TRUE : FALSE;
	FreeLibrary(hInstance);
	return bRetval;
}

bool SetSIPState(bool bState)
{
#if (_WIN32_WCE != 200) && defined(_WIN32_WCE_PSPC) //**MARCH99 - no aygshell/SIP in HPC
	SIPINFO si;

	bool bRetval;

#if defined(_WIN32_WCE_EMULATION)
	return false;//**MARCH99
#endif
	memset( &si, 0, sizeof( si ) );
	si.cbSize = sizeof( si );
	
	if(!mySHSipInfo(SPI_GETSIPINFO,0,&si,0))
		return false;
	if(bState && !(si.fdwFlags&SIPF_ON))
	{
		si.fdwFlags|=SIPF_ON;
		bRetval=mySHSipInfo(SPI_SETSIPINFO,0,&si,0);
	}
	else if (!bState && (si.fdwFlags&SIPF_ON ))
	{
		si.fdwFlags&=~SIPF_ON;
		bRetval=mySHSipInfo(SPI_SETSIPINFO,0,&si,0);
	}
	
	return bRetval;
#else
	return false;
#endif
}

bool GetSIPState()
{
#if (_WIN32_WCE != 200) && defined(_WIN32_WCE_PSPC) //**MARCH99 - no aygshell/SIP in HPC
	SIPINFO si;

#if defined(_WIN32_WCE_EMULATION)
	return false;//**MARCH99
#endif

	memset( &si, 0, sizeof( si ) );
	si.cbSize = sizeof( si );
	
	
	if(!mySHSipInfo(SPI_GETSIPINFO,0,&si,0))
		return false;

	return si.fdwFlags&SIPF_ON;
#else
	return false; //always false for HPC 2.0
#endif
}

void ClipToVisibleScreenRect(RECT *pRect)
{
#if (_WIN32_WCE != 200) && defined(_WIN32_WCE_PSPC) //**MARCH99 - no aygshell/SIP in HPC
	SIPINFO si;

#if defined(_WIN32_WCE_EMULATION)
	return;//**MARCH99
#endif

	
	memset( &si, 0, sizeof( si ) );
	si.cbSize = sizeof( si );
	
	if(mySHSipInfo(SPI_GETSIPINFO,0,&si,0))
	{
		CopyRect(pRect,&si.rcVisibleDesktop);
	}
#endif //not for HPC 2.0
	return;
}

void SetWaitCursor(BOOL bWait)
{
#ifdef _POCKET
   doWriteDebug(TEXT("26"));
   if (gpOutputWindow)
   {
   if( bWait )
      gpOutputWindow->BeginWaitCursor();
   else
      gpOutputWindow->EndWaitCursor();
   }
#else
   HCURSOR hCur;

   if(bWait)
      //SetCursor((HICON)LoadImage(NULL, IDC_WAIT,IMAGE_ICON,0,0,LR_DEFAULTCOLOR));
      hCur=LoadCursorW(NULL,IDC_WAIT);
   else
#  if(_WIN32_WCE != 200)  //**MARCH99 - no arrow cursor in HPC
      hCur=LoadCursorW(NULL,IDC_ARROW);
#  else
      hCur=NULL;
#  endif
   SetCursor(hCur);
#endif
}


#ifdef _POCKET
void MenuStripString( LPTSTR lpsz, bool bStripTab )
{
   int n = 0;
   for( UINT i = 0; i < _tcslen( lpsz ); i++ )
   {
      if( lpsz[i] == _T( '&' ) )
         continue;
      if( bStripTab && lpsz[i] == _T( '\t' ) )
         break;
      lpsz[n++] = lpsz[i];
   }
   lpsz[n] = _T( '\0' );
}
#endif